/*
     DallasTemperature.CPP -  Dallas Temperature Control Library 1.0.0
     Author: Miles Burton, <Removed for privacy>
     Website: http://milesburton.com/wiki
     Copyright (c) 2009 Miles Burton All Rights Reserved

     This library is free software; you can redistribute it and/or
     modify it under the terms of the GNU Lesser General Public
     License as published by the Free Software Foundation; either
     version 2.1 of the License, or (at your option) any later version.

     This library is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public
     License along with this library; if not, write to the Free Software
     Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     This code has been derived from: http://www.arduino.cc/playground/Learning/OneWire. Unknown author, unknown date

     You will need a 4.7K Ohm Resistor to "pull-up" the 1-Wire data line. You may use any combination of resistors 5x1k etc.
     If you are using the DS18B20, ground pins 1 and 3. The centre pin is the data line '1-wire'.
     
     Devices supported:
     DS18B20
     DS18S20 - Please note there appears to be an issue with this series.
     DS1820
     
     You may extend this functionality through strategies. Please post on Arduino.cc and contribute to the project
     
*/

#include <DallasTemperature.h>

DallasTemperature tempSensor; // You may instantiate as many copies as you require.

void setup(void) {
 // initialize inputs/outputs
 // start serial port
 Serial.begin(9600);
 tempSensor.begin(12); // Data wire is plugged into port 12 on the Arduino
 Serial.println("Dallas Temperature IC Control Library 1.0. Miles Burton");
}


void loop(void) {

   // Ask the library whether the device is valid
   switch(tempSensor.isValid())
   {
       case 1:
           Serial.println("Invalid CRC");
                 tempSensor.reset(); // Attempts to redetect IC
           return;
       case 2:
           Serial.println("Not a valid device");
                 tempSensor.reset(); // Attempts to redetect IC
           return;
   }

 // getTemperature returns a float. 
     
 Serial.print(tempSensor.getTemperature());
 Serial.print("C");
 Serial.println();
 Serial.print(DallasTemperature::toFahrenheit(tempSensor.getTemperature())); // Use the inbuild Celcius to Fahrenheit conversion. Returns a float
 Serial.print("F");
 Serial.println();
}
