/*
Simple library for sound volume manipulation by unknown author
received long time ago from some of FIDONet users. :)
Small modifications by Giordano Bruno (GiordanoFilippoBruno at domain gmail.com)
*/

#include "windows.h"
#include "mmsystem.h"
#include "Volume.h"
#include "math.h"

CVolume::CVolume()
{
	lpmxcdu = NULL;
}

CVolume::~CVolume()
{
	Close();
}

BOOL CVolume::Open(HWND Window, DWORD Line)
{
	Close();	// ,  

	// 
	m_CurrentLine = 0;
	m_SelectedMixer = 0; m_SelectedMixer--;
	m_SelectedLine = Line;
	EnumDevices(&EnumProc,(DWORD)this);

	// 
	mxl.cbStruct = sizeof(MIXERLINE);
	mxlcs.cbStruct = sizeof(MIXERLINECONTROLS);
	mxc.cbStruct = sizeof(MIXERCONTROL);
	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS);

	mmr = mixerGetNumDevs();
	// 0 
	mmr = mixerOpen(&hmx,m_SelectedMixer,(DWORD)Window,0,Window==NULL ? 0 : CALLBACK_WINDOW);
	if (mmr!=MMSYSERR_NOERROR) return FALSE;

//	//  
//	mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS;
//	mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT;
//	mmr = mixerGetLineInfo((HMIXEROBJ)hmx,&mxl,MIXER_OBJECTF_MIXER | MIXER_GETLINEINFOF_COMPONENTTYPE);
	mxl.dwLineID = m_SelectedLineId;
	mmr = mixerGetLineInfo((HMIXEROBJ)hmx,&mxl,MIXER_OBJECTF_MIXER | MIXER_GETLINEINFOF_LINEID);
	if (mmr!=MMSYSERR_NOERROR) return FALSE;

	//  
	mxlcs.cControls = 1;
	mxlcs.dwLineID = mxl.dwLineID;
	mxlcs.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
	mxlcs.cbmxctrl = sizeof(MIXERCONTROL);
	mxlcs.pamxctrl = &mxc;
	mmr = mixerGetLineControls((HMIXEROBJ)hmx,&mxlcs,MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE);
	if (mmr!=MMSYSERR_NOERROR) return FALSE;
	m_MaxVolume = mxc.Bounds.dwMaximum;
	m_MinBallanceVolume = m_MaxVolume/mxc.Metrics.cSteps;

	//      
	//     
	detailssize = sizeof(MIXERCONTROLDETAILS_UNSIGNED)*mxl.cChannels;
	lpmxcdu = new MIXERCONTROLDETAILS_UNSIGNED[mxl.cChannels];
	lpsafeballance = new MIXERCONTROLDETAILS_UNSIGNED[mxl.cChannels];

	// MixerConrolDetails
	mxcd.dwControlID = mxc.dwControlID;
	mxcd.cChannels = mxl.cChannels;
	mxcd.cMultipleItems = mxc.cMultipleItems;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	mxcd.paDetails = lpmxcdu;
	return TRUE;
}

void CVolume::Close()
{
	if (lpmxcdu!=NULL){
		delete[] lpmxcdu;
		delete[] lpsafeballance;
		mixerClose(hmx);
		lpmxcdu = NULL;
	}
}

int CVolume::EnumProc(DWORD type, MIXERCAPS* lpmxcaps, MIXERLINE* lpmxl, DWORD dwUserValue)
{
	CVolume* lpVolume = (CVolume*)dwUserValue;
	if (type==TYPE_MIXER)
		lpVolume->m_SelectedMixer++;
	if (lpVolume->m_CurrentLine==lpVolume->m_SelectedLine) {
		if (type==TYPE_MIXER) {
			lpVolume->m_CurrentLine--;
		} else {
			lpVolume->m_SelectedLineId = lpmxl->dwLineID;
			return 1;
		}
	}
	lpVolume->m_CurrentLine++;
	return 0;
}

//MY - 0..65535 THEIR -     -
#define NORMALIZETOMY(x) ( (m_MaxVolume==65535)? x : ((m_MaxVolume<65535)?(x*65535)/m_MaxVolume : 65535/(m_MaxVolume/x) ) )
#define NORMALIZETOTHEIR(x) ( (m_MaxVolume==65535)? x : ((m_MaxVolume<65535)?(x*m_MaxVolume)/65535 : x*(m_MaxVolume/65535) ) )

DWORD CVolume::GetVolume()
{
	DWORD i;
	maxi = 0;
	mmr = mixerGetControlDetails((HMIXEROBJ)hmx,&mxcd,MIXER_OBJECTF_HMIXER  | MIXER_GETCONTROLDETAILSF_VALUE);
	for (i = 0; i<mxcd.cChannels; i++) {
		if (lpmxcdu[i].dwValue>lpmxcdu[maxi].dwValue) maxi = i;
	}
	return NORMALIZETOMY(lpmxcdu[maxi].dwValue);
}

void CVolume::SetVolume(DWORD Volume)
{
	DWORD i;
	Volume = NORMALIZETOTHEIR(Volume);
	m_LastVolume=NORMALIZETOTHEIR(GetVolume());

	if (m_LastVolume>m_MinBallanceVolume) {
		ballancemaxi = maxi;
		m_BallanceVolume = m_LastVolume;
		memcpy(lpsafeballance,lpmxcdu,detailssize);
	}
	else {
		maxi = ballancemaxi;
		m_LastVolume = m_BallanceVolume;
		memcpy(lpmxcdu,lpsafeballance,detailssize);
	}

	if (m_LastVolume!=0) {
		double mm = Volume;
		mm = mm/m_LastVolume;
		for (i = 0; i<mxcd.cChannels; i++)
			lpmxcdu[i].dwValue = (int)ceil(mm*lpmxcdu[i].dwValue);
		lpmxcdu[maxi].dwValue = Volume;
	} else
		for (i = 0; i<mxcd.cChannels; i++)
			lpmxcdu[i].dwValue = Volume;
	mmr = mixerSetControlDetails((HMIXEROBJ)hmx,&mxcd,MIXER_OBJECTF_HMIXER  | MIXER_GETCONTROLDETAILSF_VALUE);
}

void CVolume::EnumDevices(ENUMDEVICESFUNC EnumFunc, DWORD dwUserValue)
{
	HMIXER hmx;
	UINT NumDevs,NumLines,i,j,k;
	MMRESULT mmr;
	MIXERLINE mxl;
	MIXERCAPS mxcaps;
	int code=0;

	mxl.cbStruct = sizeof(MIXERLINE);

	NumDevs = mixerGetNumDevs();
	for (i = 0; (i<NumDevs) && (code==0); i++) {
		mmr = mixerOpen(&hmx,i,0,0,0);
		mixerGetDevCaps(i,&mxcaps,sizeof(mxcaps));
		code = EnumFunc(TYPE_MIXER,&mxcaps,&mxl,dwUserValue);

		for (j = 0; (j<mxcaps.cDestinations) && (code==0); j++) {
			mxl.dwDestination = j;
			mmr = mixerGetLineInfo((HMIXEROBJ)hmx,&mxl,MIXER_OBJECTF_MIXER | MIXER_GETLINEINFOF_DESTINATION);
			code = EnumFunc(TYPE_LINEDESTINATION,&mxcaps,&mxl,dwUserValue);

			NumLines = mxl.cConnections;
			for (k = 0; (k<NumLines) && (code==0); k++) {
				mxl.dwSource = k;
				mmr = mixerGetLineInfo((HMIXEROBJ)hmx,&mxl,MIXER_OBJECTF_MIXER | MIXER_GETLINEINFOF_SOURCE);
				code = EnumFunc(TYPE_LINESOURCE,&mxcaps,&mxl,dwUserValue);
			}
		}
		mixerClose(hmx);
	}
}
