/*
Simple library for COM-port by Giordano Bruno (GiordanoFilippoBruno at domain gmail.com)
*/

#include <windows.h>
#include <stdio.h>
#include "com_tiny.h"

HANDLE com_InitPort(char* sPort, int speed)
{
	DCB dcbComPort;
	COMMTIMEOUTS ctmoComPort;
	HANDLE hComPort;

	hComPort = CreateFile(sPort, GENERIC_READ | GENERIC_WRITE, 0,
						NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if (hComPort != INVALID_HANDLE_VALUE) {
		ctmoComPort.ReadIntervalTimeout = MAXDWORD;
		ctmoComPort.ReadTotalTimeoutMultiplier = MAXDWORD;
		ctmoComPort.ReadTotalTimeoutConstant = MAXDWORD-1;
		ctmoComPort.WriteTotalTimeoutMultiplier = 0;
		ctmoComPort.WriteTotalTimeoutConstant = 0;
		SetCommTimeouts(hComPort, &ctmoComPort);

		dcbComPort.DCBlength = sizeof(DCB);
		GetCommState(hComPort, &dcbComPort);
		dcbComPort.BaudRate = speed;
		dcbComPort.fParity = false;
		dcbComPort.fOutxCtsFlow = false;
		dcbComPort.fOutxDsrFlow = false;
		dcbComPort.fDtrControl = true;
		dcbComPort.fDsrSensitivity = false;
		dcbComPort.ByteSize = 8;
		dcbComPort.Parity = NOPARITY;
		dcbComPort.StopBits = ONESTOPBIT;
		dcbComPort.fRtsControl = RTS_CONTROL_DISABLE;
		SetCommState(hComPort, &dcbComPort);
	}

	return hComPort;
}

void com_ClosePort(HANDLE hComPort) {
	PurgeComm(hComPort, PURGE_RXABORT);
	CloseHandle(hComPort);
}

void com_printf(HANDLE hComPort, const char* format, ...) {
	static char buf[4096];
	va_list args;
	unsigned long tmp;

	va_start(args, format);
	vsprintf(buf, format, args);
	va_end(args);

	WriteFile(hComPort, buf, strlen(buf), &tmp, NULL);
}

bool com_ReadLine(HANDLE hComPort, char* pBuf, int BufSize) {
	int i = 0;
	unsigned long tmp = 0;
	bool bNoErr;
	pBuf[i] = 0;

	do {
		i+= tmp;
		bNoErr = ReadFile(hComPort, &pBuf[i], 1, &tmp, NULL);
	} while ( (pBuf[i] != '\n') && (i<BufSize-1) && bNoErr);
	pBuf[i] = 0;
	return bNoErr;
}
