/*
Simple library to process signal from ADC. It ignores small signal variations
(to remove noise) and changes signal to border value when signal is near it.
Useful to read values from potentiometer - you will get exactly 0 on one
end (not 1, 2, or 3), and exectly 1023 on another (not 1022, 1021).
It also detects big signal changes (when you move potentiometer) and
ignores small changes, caused by noise.

Code by Giordano Bruno (GiordanoFilippoBruno at domain gmail.com)

How to use:
Just copy CDeadAndLimit.h and CDeadAndLimit.pde to your sketch folder
and include CDeadAndLimit.h in your .pde file.

Example:
---
#include "CDeadAndLimit.h"

void setup()
{
  Serial.begin(9600);
}

CDeadAndLimit dz;

void loop() {
  int i;
  //here we read new value from ADC ch0 and check, whether signal is changed
  if (dz.Check(analogRead(0))) {
    //if it's shanged - we print new value
    Serial.println(dz.Val, DEC);
  }
  delay(5);
}
---
*/

#include "CDeadAndLimit.h"

CDeadAndLimit::CDeadAndLimit() {
  SetParams(10, 0, 1023);
  Val = -DeadZone-1;
}

int CDeadAndLimit::SetParams(int NewDeadZone, int NewMin, int NewMax) {
  DeadZone = NewDeadZone;
  Min = NewMin;
  Max = NewMax;
}

bool CDeadAndLimit::Check(int NewVal) {
  if ( (NewVal < Min+DeadZone) && (Val != Min) ) {
    Val = Min;
    return true;
  }
  if ( (NewVal > Max-DeadZone) && (Val != Max) ) {
    Val = Max;
    return true;
  }
  if (abs(Val-NewVal) > DeadZone) {
    Val = NewVal;
    return true;
  } else {
    return false;
  }
}
