/*
Simple library for command-line parsing by Eric Tetz
http://www.codeguru.com/cpp/w-p/win32/article.php/c1427
*/

#include <windows.h>
#include "cmdlineargs.h"

CmdLineArgs::CmdLineArgs() {
	// Save local copy of the command line string, because
	// ParseCmdLine() modifies this string while parsing it.
	PSZ cmdline = GetCommandLine();
	m_cmdline = new char [strlen (cmdline) + 1];
	if (m_cmdline) {
		strcpy (m_cmdline, cmdline);
		ParseCmdLine();
	}
}

CmdLineArgs::~CmdLineArgs() {
	delete m_cmdline;
}

void CmdLineArgs::ParseCmdLine () {
	enum { TERM  = '\0',
		QUOTE = '\"' };

	bool bInQuotes = false;
	PSZ pargs = m_cmdline;

	while (*pargs) {
		while (isspace (*pargs))        // skip leading whitespace
			pargs++;

		bInQuotes = (*pargs == QUOTE);  // see if this token is quoted

		if (bInQuotes)                  // skip leading quote
			pargs++;

		push_back (pargs);              // store position of current token

		// Find next token.
		// NOTE: Args are normally terminated by whitespace, unless the
		// arg is quoted.  That's why we handle the two cases separately,
		// even though they are very similar.
		if (bInQuotes) {
			// find next quote followed by a space or terminator
			while (*pargs && !(*pargs == QUOTE && (isspace (pargs[1]) || pargs[1] == TERM)))
				pargs++;
			if (*pargs) {
				*pargs = TERM;  // terminate token
				if (pargs[1])   // if quoted token not followed by a terminator
					pargs += 2; // advance to next token
			}
		} else {
			// skip to next non-whitespace character
			while (*pargs && !isspace (*pargs))
				pargs++;
			if (*pargs && isspace (*pargs)) { // end of token
				*pargs = TERM;    // terminate token
				pargs++;         // advance to next token or terminator
			}
		}
	} // while (*pargs)
} // ParseCmdLine()
